# MAFIA MAILER - Professional Email Marketing System

A powerful, single-file email marketing system with professional features including installation wizard, admin authentication, and multi-profile rotation sending.

## ✨ Features

### 🎯 Core Features
- **Multi-Profile SMTP/API Sending**: Support for multiple sending profiles with automatic rotation
- **Contact List Management**: Import and manage contact lists via CSV or manual entry
- **Real-Time Campaign Progress**: Live progress tracking for sending campaigns
- **Email Tracking**: Track opens, clicks, bounces, and unsubscribes
- **Visual Email Editor**: Drag-and-drop email builder with HTML code editor
- **Professional UI**: Modern, responsive interface inspired by SendGrid

### 🆕 Enhanced Features
- **Installation Wizard**: Beautiful first-time setup wizard for database configuration
- **Admin Authentication**: Secure login system with password hashing
- **Automatic Table Creation**: Database schema created automatically during installation
- **Bug Fixes**: Fixed critical issue where campaigns could get stuck at "SENDING" status

## 🚀 Installation

### Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- PDO MySQL extension enabled

### Quick Start

1. **Upload Files**: Upload all files to your web server

2. **Access Installation Wizard**: Navigate to `mail.php` in your browser

3. **Configure Database**: The installation wizard will guide you through:
   - Database connection details (host, name, username, password)
   - Admin account creation
   - Automatic table creation

4. **Login**: After installation, you'll be redirected to the login page

5. **Start Sending**: Configure your SMTP/API profiles and start sending campaigns!

## 📋 Configuration

### Database Configuration
The installation wizard creates a `config.php` file with your database credentials. This file is automatically excluded from version control via `.gitignore`.

### Manual Configuration (Advanced)
If you need to manually configure the system, copy `config.php.example` to `config.php` and edit the values:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');
define('DB_USER', 'your_database_user');
define('DB_PASS', 'your_database_password');
define('INSTALLED', true);
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD_HASH', 'your_hashed_password');
```

## 🔧 Features & Usage

### Sending Profiles
Configure multiple SMTP servers or API endpoints:
- SMTP with TLS/SSL support
- API integration (SendGrid, Mailgun, etc.)
- Per-profile connection limits and batch sizes
- Automatic rotation across profiles

### Campaigns
- Create campaigns with visual editor or HTML code
- Preview emails before sending
- Send test messages
- Schedule sends (send immediately or later)
- Real-time progress tracking

### Contact Management
- Create multiple contact lists
- Import contacts via CSV
- Manual contact entry
- Automatic unsubscribe handling

### Tracking & Analytics
- Real-time open tracking
- Click tracking with redirect
- Bounce detection
- Unsubscribe management
- Per-campaign statistics
- Per-profile performance metrics

## 🐛 Bug Fixes

### Campaign Status Bug (Fixed)
**Issue**: Campaigns would sometimes remain stuck at "SENDING" status even after all emails were sent, especially when using worker processes or background sending.

**Solution**: 
- Enhanced status update logic with try-finally blocks
- Added fallback status update mechanisms
- Improved error handling and logging
- Ensured final status update always executes regardless of errors

## 🔐 Security

- Admin passwords are hashed using PHP's `password_hash()` function
- Session-based authentication
- SQL injection protection via PDO prepared statements
- XSS protection via output escaping
- Configuration file excluded from version control

## 📱 UI/UX

### Professional Interface
- Modern gradient color scheme
- Responsive design
- Clean, intuitive navigation
- Real-time progress indicators
- Toast notifications
- Modal dialogs

### Branding
- Customizable brand name (default: MAFIA MAILER)
- Professional login and installation pages
- Consistent styling throughout

## 🛠 Technical Details

### Architecture
- Single-file application (mail.php)
- Modular design with separate login/install pages
- PDO for database operations
- Session-based authentication
- Background worker support via `pcntl_fork()` or `fastcgi_finish_request()`

### Database Tables
- `campaigns`: Campaign information and status
- `sending_profiles`: SMTP/API configuration
- `contact_lists`: Contact list management
- `contacts`: Individual contact records
- `events`: Email events (opens, clicks, bounces)
- `unsubscribes`: Unsubscribe list
- `rotation_settings`: Rotation configuration

### Worker Modes
1. **FastCGI Mode**: Uses `fastcgi_finish_request()` for background sending
2. **Fork Mode**: Uses `pcntl_fork()` for concurrent workers
3. **Synchronous Mode**: Fallback for environments without background support

## 📝 Changelog

### Version 1.0
- ✅ Added installation wizard with professional UI
- ✅ Implemented admin authentication system
- ✅ Fixed campaign status stuck bug
- ✅ Enhanced error handling and logging
- ✅ Updated branding to "MAFIA MAILER"
- ✅ Created configuration management system
- ✅ Added .gitignore for security

## 🤝 Support

For issues, questions, or feature requests, please contact the development team or create an issue in the repository.

## 📄 License

This software is provided as-is for email marketing purposes. Please ensure compliance with anti-spam laws and regulations in your jurisdiction.

---

**MAFIA MAILER** - Professional Email Marketing Made Easy 🚀
